#!/bin/sh
. "/opt/TrendMicro/DTAS/ManagementServer/bin/common.sh"

parent_pid="${1}"
status_file="${2}"
step_file="${3}"

update() {
	local status="${1}"
	echo "${status}" > "${status_file}"
	kill -USR1 "${parent_pid}"
}

msg=""

php backend.php deploy "${step_file}"
if [ "${?}" -ne 0 ]; then
	msg=`echo -e "-1\ncall backend deploy error"`
	update "${msg}"
	exit 1
fi

# waiting deploy daemon actually started
sleep 3

while [ 1 ];
do
	msg=`php backend.php get_deployment_status`
    ret="${?}"
	if [ "${ret}" -ne 0 ]; then
        errMsg="GetDeploymentStatusFail: ret='${ret}', msg='${msg}'"
        debug_print "${errMsg}"
        
		update "`echo -e "-1\n${errMsg}"`"
		break
	fi
	update "${msg}"

    overall_progress=`echo -e ${msg} | cut -d " " -f1`
    if [ "${overall_progress}" -ge 100 ]; then
        debug_print "DeploymentDone: overallProgress='${overall_progress}'"
        break
    fi

	sleep 1
done
